/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.CrusherRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingUtils {
    public static Set<ItemStack[]> missingRecipes = new HashSet<ItemStack[]>();
    private static HashMap<ItemStack, ItemStack> cachedRecipes = new HashMap();

    public static ItemStack findOutput(int size, ItemStack input, Level world) {
        if (input.m_41613_() < size * size) {
            return ItemStack.f_41583_;
        }
        ItemStack cachedStack = input.m_41777_();
        cachedStack.m_41764_(size * size);
        for (Map.Entry<ItemStack, ItemStack> entry : cachedRecipes.entrySet()) {
            if (!entry.getKey().m_41656_(cachedStack) || entry.getKey().m_41613_() != cachedStack.m_41613_()) continue;
            return entry.getValue().m_41777_();
        }
        CraftingContainer inventoryCrafting = new CraftingContainer(new AbstractContainerMenu(null, 0){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player playerIn) {
                return false;
            }
        }, size, size);
        for (int i = 0; i < size * size; ++i) {
            inventoryCrafting.m_6836_(i, input.m_41777_());
        }
        CraftingRecipe recipe = world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)inventoryCrafting, world).orElse(null);
        if (recipe != null) {
            ItemStack output = recipe.m_8043_();
            cachedRecipes.put(cachedStack, output.m_41777_());
            return output.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static CraftingContainer genCraftingInventory(Level world, ItemStack ... inputs) {
        CraftingContainer inventoryCrafting = new CraftingContainer(new AbstractContainerMenu(null, 0){

            public boolean m_6875_(Player playerIn) {
                return false;
            }

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return ItemStack.f_41583_;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inventoryCrafting.m_6836_(i, inputs[i]);
        }
        return inventoryCrafting;
    }

    public static Recipe findRecipe(Level world, ItemStack ... inputs) {
        for (ItemStack[] missingRecipe : missingRecipes) {
            if (!CraftingUtils.doesStackArrayEquals(missingRecipe, inputs)) continue;
            return null;
        }
        Recipe recipe = (Recipe)world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)CraftingUtils.genCraftingInventory(world, inputs), world).orElseGet(null);
        if (recipe == null) {
            missingRecipes.add(inputs);
        }
        return recipe;
    }

    public static boolean doesStackArrayEquals(ItemStack[] original, ItemStack[] compare) {
        if (original.length != compare.length) {
            return false;
        }
        for (int i = 0; i < original.length; ++i) {
            if (original[i].m_41619_() && compare[i].m_41619_() || original[i].m_41656_(compare[i])) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getCrushOutput(Level world, ItemStack stack) {
        for (CrusherRecipe recipe : RecipeUtil.getRecipes((Level)world, (RecipeType)((RecipeType)ModuleCore.CRUSHER_TYPE.get()))) {
            if (!recipe.input.test(stack)) continue;
            return recipe.output.m_43908_()[0];
        }
        return ItemStack.f_41583_;
    }
}

